#ifndef MOUTLINER_H__
#define MOUTLINER_H__

enum
{
/// TAB GROUPS

	OUTLINEMAT_GROUP_BASIC = 2000,
	OUTLINEMAT_GROUP_LINE,
	OUTLINEMAT_GROUP_STROKE,
	OUTLINEMAT_GROUP_BRUSH,
	OUTLINEMAT_GROUP_THICKNESS,
	OUTLINEMAT_GROUP_OPACITY,
	OUTLINEMAT_GROUP_DISTORTION,
	OUTLINEMAT_GROUP_SCENE,
	OUTLINEMAT_GROUP_ANIMATE,
	OUTLINEMAT_GROUP_CLONE,
	OUTLINEMAT_GROUP_ADJUSTMENT,
	OUTLINEMAT_GROUP_PREVIEW,
	OUTLINEMAT_GROUP_SHADING,
	OUTLINEMAT_GROUP_ASSIGN,
	OUTLINEMAT_GROUP_MULTIPASS,
	OUTLINEMAT_GROUP_EDITORLINES,

// SUBGROUPS

	OUTLINEMAT_GROUP_LINE_OUTLINE = 3000,
	OUTLINEMAT_GROUP_LINE_FOLD,
	OUTLINEMAT_GROUP_LINE_OVERLAPS,
	OUTLINEMAT_GROUP_LINE_CREASE,
	OUTLINEMAT_GROUP_LINE_INTERSECTION,
	OUTLINEMAT_GROUP_LINE_BORDER,
	OUTLINEMAT_GROUP_LINE_EDGES,
	OUTLINEMAT_GROUP_LINE_ANGLE,
	OUTLINEMAT_GROUP_LINE_CONTOUR,
	OUTLINEMAT_GROUP_LINE_ISOPARMS,
	OUTLINEMAT_GROUP_LINE_MATERIAL,
	OUTLINEMAT_GROUP_LINE_TRI,
	OUTLINEMAT_GROUP_LINE_SPLINES,
	OUTLINEMAT_GROUP_LINE_TYPES,

	OUTLINEMAT_GROUP_OPACITY_DISTANCE,
	OUTLINEMAT_GROUP_OPACITY_POSITION,
	OUTLINEMAT_GROUP_OPACITY_SCALE,
	OUTLINEMAT_GROUP_OPACITY_LENGTH,
	OUTLINEMAT_GROUP_OPACITY_FACEANGLE,
	OUTLINEMAT_GROUP_OPACITY_JOINANGLE,
	OUTLINEMAT_GROUP_OPACITY_SCREENANGLE,
	OUTLINEMAT_GROUP_OPACITY_FROMEDGE,
	OUTLINEMAT_GROUP_OPACITY_TEXTURE,
	OUTLINEMAT_GROUP_OPACITY_VERTEX,
	OUTLINEMAT_GROUP_OPACITY_ILLUMINATION,
	OUTLINEMAT_GROUP_OPACITY_NOISE,
	OUTLINEMAT_GROUP_OPACITY_COFFEE,
	OUTLINEMAT_GROUP_OPACITY_SCREENTEXTURE,
	OUTLINEMAT_GROUP_OPACITY_SLENGTH,
	OUTLINEMAT_GROUP_OPACITY_CURVATURE,
	OUTLINEMAT_GROUP_OPACITY_MAP,
	OUTLINEMAT_GROUP_OPACITY_MODIFIERS,

	OUTLINEMAT_GROUP_THICKNESS_DISTANCE,
	OUTLINEMAT_GROUP_THICKNESS_POSITION,
	OUTLINEMAT_GROUP_THICKNESS_SCALE,
	OUTLINEMAT_GROUP_THICKNESS_LENGTH,
	OUTLINEMAT_GROUP_THICKNESS_FACEANGLE,
	OUTLINEMAT_GROUP_THICKNESS_JOINANGLE,
	OUTLINEMAT_GROUP_THICKNESS_SCREENANGLE,
	OUTLINEMAT_GROUP_THICKNESS_VERTEX,
	OUTLINEMAT_GROUP_THICKNESS_ILLUMINATION,
	OUTLINEMAT_GROUP_THICKNESS_NOISE,
	OUTLINEMAT_GROUP_THICKNESS_COFFEE,
	OUTLINEMAT_GROUP_THICKNESS_SLENGTH,
	OUTLINEMAT_GROUP_THICKNESS_CURVATURE,
	OUTLINEMAT_GROUP_THICKNESS_SCREENTEXTURE,
	OUTLINEMAT_GROUP_THICKNESS_MAP,
	OUTLINEMAT_GROUP_THICKNESS_MODIFIERS,

	OUTLINEMAT_GROUP_COLOR_DISTANCE,
	OUTLINEMAT_GROUP_COLOR_POSITION,
	OUTLINEMAT_GROUP_COLOR_SCALE,
	OUTLINEMAT_GROUP_COLOR_LENGTH,
	OUTLINEMAT_GROUP_COLOR_FACEANGLE,
	OUTLINEMAT_GROUP_COLOR_JOINANGLE,
	OUTLINEMAT_GROUP_COLOR_SCREENANGLE,
	OUTLINEMAT_GROUP_COLOR_FROMEDGE,
	OUTLINEMAT_GROUP_COLOR_TEXTURE,
	OUTLINEMAT_GROUP_COLOR_VERTEX,
	OUTLINEMAT_GROUP_COLOR_ILLUMINATION,
	OUTLINEMAT_GROUP_COLOR_NOISE,
	OUTLINEMAT_GROUP_COLOR_COFFEE,
	OUTLINEMAT_GROUP_COLOR_CURVATURE,
	OUTLINEMAT_GROUP_COLOR_FROMSURFACE,
	OUTLINEMAT_GROUP_COLOR_SCREENTEXTURE,
	OUTLINEMAT_GROUP_COLOR_SLENGTH,
	OUTLINEMAT_GROUP_COLOR_MAP,
	OUTLINEMAT_GROUP_COLOR_MODIFIERS,

	OUTLINEMAT_GROUP_LINE_PARTICLES,
	OUTLINEMAT_GROUP_LINE_MOTION,
	OUTLINEMAT_GROUP_LINE_ZDELTA,

	OUTLINEMAT_GROUP_ADJUSTMENT_OFFSET,
	OUTLINEMAT_GROUP_ADJUSTMENT_TRANSFORM,
	OUTLINEMAT_GROUP_ADJUSTMENT_OVERSHOOT,
	OUTLINEMAT_GROUP_ADJUSTMENT_REPOSITION,
	OUTLINEMAT_GROUP_ADJUSTMENT_STROKE,
	OUTLINEMAT_GROUP_ADJUSTMENT_HSV,

	OUTLINEMAT_GROUP_CLONE_VARIATIONS,
	OUTLINEMAT_GROUP_CLONE_TRANSFORM,

	// PAGES

	OUTLINEMAT_PAGE_BASIC = 4000,
	OUTLINEMAT_PAGE_STROKE,
	OUTLINEMAT_PAGE_BRUSH,
	OUTLINEMAT_PAGE_THICKNESS,
	OUTLINEMAT_PAGE_OPACITY,
	OUTLINEMAT_PAGE_DISTORTION,
	OUTLINEMAT_PAGE_SCENE,
	OUTLINEMAT_PAGE_ANIMATE,
	OUTLINEMAT_PAGE_CLONE,
	OUTLINEMAT_PAGE_ADJUSTMENT,
	OUTLINEMAT_PAGE_PREVIEW,
	OUTLINEMAT_PAGE_ASSIGN,

// LINES TAB

	OUTLINEMAT_LINE_TAB_START = 10000,	// --- START MARKER ---

	//

	OUTLINEMAT_LINE_OUTLINE,	// DO NOT CHANGE >> LINKED TO PREFS ALSO
	OUTLINEMAT_LINE_FOLD,
	OUTLINEMAT_LINE_OVERLAPS,
	OUTLINEMAT_LINE_MATERIAL,
	OUTLINEMAT_LINE_CREASE,
	OUTLINEMAT_LINE_INTERSECTION,
	OUTLINEMAT_LINE_BORDER,
	OUTLINEMAT_LINE_EDGES,
	OUTLINEMAT_LINE_ANGLE,
	OUTLINEMAT_LINE_CONTOUR,
	OUTLINEMAT_LINE_ISOPARMS,
	OUTLINEMAT_LINE_TRI,
	OUTLINEMAT_LINE_SPLINES,
	OUTLINEMAT_LINE_PARTICLES,
	OUTLINEMAT_LINE_MOTION,
	OUTLINEMAT_LINE_MATERIALALPHA,
	OUTLINEMAT_LINE_ZDELTA,

	//

	OUTLINEMAT_LINE_OUTLINE_SHOW,
	OUTLINEMAT_LINE_COMBINEMODE,
	OUTLINEMAT_LINE_FOLDING,

	OUTLINEMAT_LINE_DUMMY3,
	OUTLINEMAT_LINE_DUMMY4,
	OUTLINEMAT_LINE_DUMMY5,
	OUTLINEMAT_LINE_DUMMY6,
	OUTLINEMAT_LINE_DUMMY7,
	OUTLINEMAT_LINE_DUMMY8,

	OUTLINEMAT_LINE_OUTLINE_SHOW_NEAR_FROM,
	OUTLINEMAT_LINE_OUTLINE_SHOW_FAR,
	OUTLINEMAT_LINE_OUTLINE_SHOW_FAR_TO,

	OUTLINEMAT_LINE_OUTLINE_SHOW_OBJS,

	//

	OUTLINEMAT_LINE_DUMMY9,
	OUTLINEMAT_LINE_DUMMY10,

	OUTLINEMAT_LINE_DUMMY_1,
	OUTLINEMAT_LINE_DUMMY_2,

	OUTLINEMAT_LINE_ANGLE_MINTHETA,
	OUTLINEMAT_LINE_ANGLE_MAXTHETA,

	OUTLINEMAT_LINE_CREASE_MINTHETA,

	OUTLINEMAT_LINE_INTERESTION_OBJS,
	OUTLINEMAT_LINE_INTERESTION_SELF,

	OUTLINEMAT_LINE_OUTLINE_SHOW_SELFOFF,

	//

	OUTLINEMAT_LINE_OUTLINE_MAT_V,
	OUTLINEMAT_LINE_OVERLAPS_MAT_V,
	OUTLINEMAT_LINE_OVERLAPS_MAT_H,
	OUTLINEMAT_LINE_DUMMY_V,
	OUTLINEMAT_LINE_DUMMY_H,
	OUTLINEMAT_LINE_CREASE_MAT_V,
	OUTLINEMAT_LINE_CREASE_MAT_H,
	OUTLINEMAT_LINE_INTERSECTION_MAT_V,
	OUTLINEMAT_LINE_INTERSECTION_MAT_H,
	OUTLINEMAT_LINE_BORDER_MAT_V,
	OUTLINEMAT_LINE_BORDER_MAT_H,
	OUTLINEMAT_LINE_MATERIAL_MAT_V,
	OUTLINEMAT_LINE_MATERIAL_MAT_H,
	OUTLINEMAT_LINE_EDGES_MAT_V,
	OUTLINEMAT_LINE_EDGES_MAT_H,
	OUTLINEMAT_LINE_ANGLE_MAT_V,
	OUTLINEMAT_LINE_ANGLE_MAT_H,
	OUTLINEMAT_LINE_TRI_MAT_V,
	OUTLINEMAT_LINE_TRI_MAT_H,
	OUTLINEMAT_LINE_SPLINES_MAT_V,
	OUTLINEMAT_LINE_PARTICLES_MAT_V,
	OUTLINEMAT_LINE_MOTION_MAT_V,
	OUTLINEMAT_LINE_MOTION_MAT_H,
	OUTLINEMAT_LINE_CONTOUR_MAT_V,
	OUTLINEMAT_LINE_CONTOUR_MAT_H,
	OUTLINEMAT_LINE_ZDELTA_MAT_V,
	OUTLINEMAT_LINE_ZDELTA_MAT_H,
	OUTLINEMAT_LINE_FOLD_MAT_V,
	OUTLINEMAT_LINE_FOLD_MAT_H,
	OUTLINEMAT_LINE_OUTLINE_MAT_H,
	OUTLINEMAT_LINE_DEFAULT_MAT_V,
	OUTLINEMAT_LINE_DEFAULT_MAT_H,
	OUTLINEMAT_LINE_ISOPARMS_MAT_V,
	OUTLINEMAT_LINE_ISOPARMS_MAT_H,
	OUTLINEMAT_LINE_SPLINES_MAT_H,
	OUTLINEMAT_LINE_PARTICLES_MAT_H,

	//

	OUTLINEMAT_LINE_OUTLINE_SHOW_OBJECTS,
	OUTLINEMAT_LINE_OUTLINE_OUTLINE_OBJS,
	OUTLINEMAT_LINE_OUTLINE_OUTLINE_SELFOFF,
	OUTLINEMAT_LINE_OUTLINE_OUTLINE_OBJECTS,
	OUTLINEMAT_LINE_INDIVIDUALMATS,
	OUTLINEMAT_LINE_INTERESTION_OBJS_LIST,

	OUTLINEMAT_LINE_MATERIAL_MODE,
	OUTLINEMAT_LINE_MATERIAL_COMBINE,
	OUTLINEMAT_LINE_MATERIAL_TAGS,

	//

	OUTLINEMAT_LINE_MATERIAL_MODE_INCLUDE = 0,
	OUTLINEMAT_LINE_MATERIAL_MODE_EXCLUDE,

	OUTLINEMAT_LINE_INDIVIDUALMATS_DEFAULTS = 0,
	OUTLINEMAT_LINE_INDIVIDUALMATS_VISIBLE,
	OUTLINEMAT_LINE_INDIVIDUALMATS_HIDDEN,
	OUTLINEMAT_LINE_INDIVIDUALMATS_BOTH,

	//

	OUTLINEMAT_LINE_CONTOUR_MODE = 11000,
	OUTLINEMAT_LINE_CONTOUR_ANGLE,
	OUTLINEMAT_LINE_CONTOUR_POSITION,
	OUTLINEMAT_LINE_CONTOUR_UVW,

	OUTLINEMAT_LINE_CONTOUR_ANGLE_MIN,
	OUTLINEMAT_LINE_CONTOUR_ANGLE_MAX,
	OUTLINEMAT_LINE_CONTOUR_ANGLE_STEPS,

	OUTLINEMAT_LINE_CONTOUR_POSITION_MIN,
	OUTLINEMAT_LINE_CONTOUR_POSITION_MAX,
	OUTLINEMAT_LINE_CONTOUR_POSITION_STEPS,
	OUTLINEMAT_LINE_CONTOUR_POSITION_ROT,

	OUTLINEMAT_LINE_CONTOUR_UVW_MIN,
	OUTLINEMAT_LINE_CONTOUR_UVW_MAX,
	OUTLINEMAT_LINE_CONTOUR_UVW_STEPS,

	OUTLINEMAT_LINE_CONTOUR_POSITION_SPACING,
	OUTLINEMAT_LINE_CONTOUR_POSITION_OFF,
	OUTLINEMAT_LINE_CONTOUR_POSITION_SPACE,

	OUTLINEMAT_LINE_CONTOUR_POSITION_VAR,

	//

	OUTLINEMAT_LINE_PARTICLES_MODE = 12000,
	OUTLINEMAT_LINE_PARTICLES_TRAIL_LIMIT,
	OUTLINEMAT_LINE_PARTICLES_TRAIL,
	OUTLINEMAT_LINE_PARTICLES_VSCALE,
	OUTLINEMAT_LINE_PARTICLES_DEATH,
	OUTLINEMAT_LINE_PARTICLES_FADETIME,

	//

	OUTLINEMAT_LINE_MOTION_POINTS = 13000,
	OUTLINEMAT_LINE_MOTION_LINE,
	OUTLINEMAT_LINE_MOTION_SHAPE,
	OUTLINEMAT_LINE_MOTION_CURVE,
	OUTLINEMAT_LINE_MOTION_COUNT,
	OUTLINEMAT_LINE_MOTION_SCALE,
	OUTLINEMAT_LINE_MOTION_CURVEW,
	OUTLINEMAT_LINE_MOTION_SELECTEDLINES,
	OUTLINEMAT_LINE_MOTION_BACKLINE,
	OUTLINEMAT_LINE_MOTION_LINE_MODE,
	OUTLINEMAT_LINE_MOTION_TRAIL_LIMIT,
	OUTLINEMAT_LINE_MOTION_TRAIL,
	OUTLINEMAT_LINE_MOTION_FADE_OPACITY,
	OUTLINEMAT_LINE_MOTION_FADE_OPACITY_STRENGTH,
	OUTLINEMAT_LINE_MOTION_FADE_THICKNESS,
	OUTLINEMAT_LINE_MOTION_FADE_THICKNESS_STRENGTH,
	OUTLINEMAT_LINE_MOTION_TAPER,
	OUTLINEMAT_LINE_MOTION_TAPER_ANGLE,
	OUTLINEMAT_LINE_MOTION_CURVEH,
	OUTLINEMAT_LINE_MOTION_THRESHOLD,
	OUTLINEMAT_LINE_MOTION_LINEOFFSET,
	OUTLINEMAT_LINE_MOTION_OUTLINES,
	OUTLINEMAT_LINE_MOTION_LINK,
	OUTLINEMAT_LINE_MOTION_LINE2D,
	OUTLINEMAT_LINE_MOTION_LINEH,
	OUTLINEMAT_LINE_MOTION_LINEW,
	OUTLINEMAT_LINE_MOTION_SCALE_VAR,
	OUTLINEMAT_LINE_MOTION_TAPER_W,
	OUTLINEMAT_LINE_MOTION_THRESHOLD_FROM,
	OUTLINEMAT_LINE_MOTION_RELOFFSET,
	OUTLINEMAT_LINE_MOTION_RELLINEOFFSET,

	OUTLINEMAT_LINE_ZDELTA_MINZ = 14000,
	OUTLINEMAT_LINE_ZDELTA_MAXZ,
	OUTLINEMAT_LINE_ZDELTA_MOVEX,
	OUTLINEMAT_LINE_ZDELTA_MOVEZ,
	OUTLINEMAT_LINE_ZDELTA_INVERT,
	OUTLINEMAT_LINE_ZDELTA_SILHOUETTE,

	//

	OUTLINEMAT_LINE_TAB_END,	// DO NOT REMOVE OR CHANGE -- END MARKER --

	// CYCLE IDs for LINE tab

	OUTLINEMAT_LINE_CONTOUR_POSITION_SPACING_REL = 0,
	OUTLINEMAT_LINE_CONTOUR_POSITION_SPACING_ABS,

	OUTLINEMAT_LINE_FOLDING_FRONTBACK = 0,
	OUTLINEMAT_LINE_FOLDING_BACKFRONT,
	OUTLINEMAT_LINE_FOLDING_BOTH,

	OUTLINEMAT_LINE_COMBINEMODE_OFF = 0,
	OUTLINEMAT_LINE_COMBINEMODE_ALL,
	OUTLINEMAT_LINE_COMBINEMODE_EXCLUSIVE,
	OUTLINEMAT_LINE_COMBINEMODE_INCLUSIVE,

	OUTLINEMAT_LINE_RENDERCLIP_OFF = 0,
	OUTLINEMAT_LINE_RENDERCLIP_IN,
	OUTLINEMAT_LINE_RENDERCLIP_OUT,

	OUTLINEMAT_LINE_PARTICLES_MODE_VELOCITY = 0,
	OUTLINEMAT_LINE_PARTICLES_MODE_TRAIL,

	OUTLINEMAT_LINE_PARTICLES_DEATH_REMAIN = 0,
	OUTLINEMAT_LINE_PARTICLES_DEATH_REMOVE,
	OUTLINEMAT_LINE_PARTICLES_DEATH_RUNOUT,
	OUTLINEMAT_LINE_PARTICLES_DEATH_FADEOUT,

	OUTLINEMAT_LINE_MOTION_LINE_MODE_VELOCITY = 0,
	OUTLINEMAT_LINE_MOTION_LINE_MODE_TRAIL,

	OUTLINEMAT_LINE_FACING_FRONT = 0,
	OUTLINEMAT_LINE_FACING_BACK,
	OUTLINEMAT_LINE_FACING_BOTH,

	OUTLINEMAT_LINE_CONTOUR_MODE_ANGLE = 0,
	OUTLINEMAT_LINE_CONTOUR_MODE_POSITION,
	OUTLINEMAT_LINE_CONTOUR_MODE_UVW,

	OUTLINEMAT_LINE_CONTOUR_OBJECT_X = 0,
	OUTLINEMAT_LINE_CONTOUR_OBJECT_Y,
	OUTLINEMAT_LINE_CONTOUR_OBJECT_Z,
	OUTLINEMAT_LINE_CONTOUR_WORLD_X,
	OUTLINEMAT_LINE_CONTOUR_WORLD_Y,
	OUTLINEMAT_LINE_CONTOUR_WORLD_Z,
	OUTLINEMAT_LINE_CONTOUR_VIEW_X,
	OUTLINEMAT_LINE_CONTOUR_VIEW_Y,
	OUTLINEMAT_LINE_CONTOUR_VIEW_Z,

	OUTLINEMAT_LINE_CONTOUR_UVW_U = 0,
	OUTLINEMAT_LINE_CONTOUR_UVW_V,
	OUTLINEMAT_LINE_CONTOUR_UVW_W,

	OUTLINEMAT_LINE_SHOW_VISIBLE = 0,
	OUTLINEMAT_LINE_SHOW_HIDDEN,
	OUTLINEMAT_LINE_SHOW_FRONT,
	OUTLINEMAT_LINE_SHOW_BACK,
	OUTLINEMAT_LINE_SHOW_ALL,

// STROKES

	OUTLINEMAT_STROKES_TAB_START = 20000,	// --- START MARKER ---

	//

	OUTLINEMAT_START,
	OUTLINEMAT_MULTCONNECTION,
	OUTLINEMAT_STROKE_DUMMY,
	OUTLINEMAT_CLOSECONNECTION,
	OUTLINEMAT_LINESTART,
	OUTLINEMAT_LINEEND,
	OUTLINEMAT_JOINT,
	OUTLINEMAT_JOINT_MITER_LIMIT,
	OUTLINEMAT_CONNECTIIONZ,
	OUTLINEMAT_CONNECTIIONT,
	OUTLINEMAT_STROKE_CONNECTZ,

	OUTLINEMAT_START_ANGLE,

	OUTLINEMAT_DIRECTION,
	OUTLINEMAT_DIRECTION_DUMMY,

	OUTLINEMAT_END,
	OUTLINEMAT_END_MAXLENGTH,
	OUTLINEMAT_END_MAXLENGTHVAR,
	OUTLINEMAT_END_MAXANGLE,
	OUTLINEMAT_END_MAXANGLEVAR,

	OUTLINEMAT_PATTERN,
	OUTLINEMAT_PATTERN_PRESET,
	OUTLINEMAT_PATTERN_SCALE,
	OUTLINEMAT_PATTERN_OFFSET,
	OUTLINEMAT_PATTERN_EDIT,
	OUTLINEMAT_PATTERN_DATA,
	OUTLINEMAT_PATTERN_PRESET_PREVIEW,

	OUTLINEMAT_FILTER_STROKES,
	OUTLINEMAT_FILTER_STROKES_MINLEN,

	OUTLINEMAT_LINE_JOIN_DUMMY,
	OUTLINEMAT_JOIN_ANGLE_LIMIT,

	OUTLINEMAT_STROKE_CONNECTW,

	OUTLINEMAT_STROKE_DUMMY1,
	OUTLINEMAT_STROKE_DUMMY2,

	OUTLINEMAT_STARTCAP_WIDTH,
	OUTLINEMAT_STARTCAP_HEIGHT,
	OUTLINEMAT_STARTCAP_TEXTURE_LINK,

	OUTLINEMAT_ENDCAP_WIDTH,
	OUTLINEMAT_ENDCAP_HEIGHT,
	OUTLINEMAT_ENDCAP_TEXTURE_LINK,

	OUTLINEMAT_TIME_COHERENCE,
	OUTLINEMAT_SPACE_COHERENCE,

	OUTLINEMAT_FILTER_STROKE_MODE,
	OUTLINEMAT_FILTER_STROKES_RELATIVE,
	OUTLINEMAT_FILTER_STROKES_OVERLAPLEN,
	OUTLINEMAT_FILTER_STROKES_OVERLAPDIST,

	//

	OUTLINEMAT_STROKES_TAB_END,	// DO NOT REMOVE OR CHANGE -- END MARKER --

	//

	OUTLINEMAT_FILTER_STROKE_MODE_PIXEL = 0,
	OUTLINEMAT_FILTER_STROKE_MODE_OBJECT,
	OUTLINEMAT_FILTER_STROKE_MODE_OVERLAP,

	//

	OUTLINEMAT_PATTERN_SOLID = 0,
	OUTLINEMAT_PATTERN_DASHED,
	OUTLINEMAT_PATTERN_DOTTED,
	OUTLINEMAT_PATTERN_CENTER,
	OUTLINEMAT_PATTERN_HIDDEN,
	OUTLINEMAT_PATTERN_PHANTOM,
	OUTLINEMAT_PATTERN_DASHDOT,
	OUTLINEMAT_PATTERN_BORDER,
	OUTLINEMAT_PATTERN_DIVIDE,
	OUTLINEMAT_PATTERN_CUSTOM,

	OUTLINEMAT_CONNECTIIONT_ALL = 0,
	OUTLINEMAT_CONNECTIIONT_TYPES,

// DISTORT

	OUTLINEMAT_DISTORT_TAB_START = 30000,	// --- START MARKER ---

	OUTLINEMAT_CURVE,
	OUTLINEMAT_CURVE_TYPE,
	OUTLINEMAT_CURVE_INTERPOLATION,
	OUTLINEMAT_CURVE_SUB,
	OUTLINEMAT_CURVE_ANGLE,

	OUTLINEMAT_CURVE_WOBBLE_FN,
	OUTLINEMAT_CURVE_WOBBLE_SPLINE,
	OUTLINEMAT_CURVE_WOBBLE_TYPE,
	OUTLINEMAT_CURVE_WOBBLE_LAMBDA,
	OUTLINEMAT_CURVE_WOBBLE_STRENGTH,
	OUTLINEMAT_CURVE_WOBBLE_NOISE_OCTAVES,
	OUTLINEMAT_CURVE_WOBBLE_SCALE,

	OUTLINEMAT_CURVE_STRENGTH,

	OUTLINEMAT_REPOSITION,
	OUTLINEMAT_REPOSITION_POSITION,
	OUTLINEMAT_REPOSITION_SCALE,
	OUTLINEMAT_REPOSITION_ROTATION,

	OUTLINEMAT_CURVE_WOBBLE_ANIMSPEED,
	OUTLINEMAT_CURVE_WOBBLE_DETAIL,
	OUTLINEMAT_CURVE_WOBBLE_LOW_CLIP,
	OUTLINEMAT_CURVE_WOBBLE_HIGH_CLIP,
	OUTLINEMAT_CURVE_WOBBLE_BRIGHTNESS,
	OUTLINEMAT_CURVE_WOBBLE_CONTRAST,
	OUTLINEMAT_CURVE_WOBBLE_NOISE_ABS,
	OUTLINEMAT_CURVE_WOBBLE_NOISE_INVERT,

	OUTLINEMAT_CURVE_NOISE_MAPPING,

	//

	OUTLINEMAT_DISTORT_TAB_END,	// DO NOT REMOVE OR CHANGE -- END MARKER --

	//

	OUTLINEMAT_CURVE_WOBBLE_FN_NONE = 0,
	OUTLINEMAT_CURVE_WOBBLE_FN_SIN,
	OUTLINEMAT_CURVE_WOBBLE_FN_NOISE,
	OUTLINEMAT_CURVE_WOBBLE_FN_SPLINE,

	OUTLINEMAT_CURVE_NOISE_MAPPING_LINE = 0,
	OUTLINEMAT_CURVE_NOISE_MAPPING_SCREEN,
	OUTLINEMAT_CURVE_NOISE_MAPPING_OBJECT,
	OUTLINEMAT_CURVE_NOISE_MAPPING_WORLD,

// ADJUSTMENT

	OUTLINEMAT_ADJUST_TAB_START = 40000,	// --- START MARKER ---

	//

	OUTLINEMAT_OVERSHOOT_START,
	OUTLINEMAT_OVERSHOOT_END,
	OUTLINEMAT_OFFSET_START,
	OUTLINEMAT_OFFSET_END,
	OUTLINEMAT_OFFSET_START_VAR,
	OUTLINEMAT_OFFSET_END_VAR,
	OUTLINEMAT_OFFSET_X,
	OUTLINEMAT_OFFSET_X_VAR,
	OUTLINEMAT_OFFSET_Y,
	OUTLINEMAT_OFFSET_Y_VAR,
	OUTLINEMAT_SCALE_X,
	OUTLINEMAT_SCALE_X_VAR,
	OUTLINEMAT_SCALE_Y,
	OUTLINEMAT_SCALE_Y_VAR,
	OUTLINEMAT_ROTATE_X,
	OUTLINEMAT_ROTATE_X_VAR,
	OUTLINEMAT_ROTATE_Y,
	OUTLINEMAT_ROTATE_Y_VAR,
	OUTLINEMAT_OVERSHOOT_RELATIVE,
	OUTLINEMAT_OVERSHOOT_START_REL,
	OUTLINEMAT_OVERSHOOT_START_VAR,
	OUTLINEMAT_OVERSHOOT_END_REL,
	OUTLINEMAT_OVERSHOOT_END_VAR,
	OUTLINEMAT_ADJUSTMENT_TRANSFORM_PIVOT,
	OUTLINEMAT_ADJUSTMENT_STROKESTART,
	OUTLINEMAT_ADJUSTMENT_STROKESTART_VAR,
	OUTLINEMAT_ADJUSTMENT_STROKEEND,
	OUTLINEMAT_ADJUSTMENT_STROKEEND_VAR,
	OUTLINEMAT_ADJUSTMENT_STROKE_RESIZE,
	OUTLINEMAT_ADJUSTMENT_STROKE_RECALC,
	OUTLINEMAT_ADJUSTMENT_HSV_H,
	OUTLINEMAT_ADJUSTMENT_HSV_S,
	OUTLINEMAT_ADJUSTMENT_HSV_V,

	//

	OUTLINEMAT_ADJUST_TAB_END,	// DO NOT REMOVE OR CHANGE -- END MARKER --

// COLOR

	OUTLINEMAT_COLOR_TAB_START = 50000,	// --- START MARKER ---

	//

	OUTLINEMAT_COLOR,

	OUTLINEMAT_COLOR_DISTANCE,
	OUTLINEMAT_COLOR_DISTANCE_MIN,
	OUTLINEMAT_COLOR_DISTANCE_MAX,
	OUTLINEMAT_COLOR_DISTANCE_SPLINE,
	OUTLINEMAT_COLOR_DISTANCE_STRENGTH,
	OUTLINEMAT_COLOR_DISTANCE_RANGE,

	OUTLINEMAT_COLOR_LENGTH,
	OUTLINEMAT_COLOR_LENGTH_MIN,
	OUTLINEMAT_COLOR_LENGTH_MAX,
	OUTLINEMAT_COLOR_LENGTH_SPLINE,
	OUTLINEMAT_COLOR_LENGTH_LOOP,
	OUTLINEMAT_COLOR_LENGTH_STRENGTH,
	OUTLINEMAT_COLOR_LENGTH_RANGE,
	OUTLINEMAT_COLOR_LENGTH_MODE,
	OUTLINEMAT_COLOR_LENGTH_MODE_INVERT,

	OUTLINEMAT_COLOR_FACEANGLE,
	OUTLINEMAT_COLOR_FACEANGLE_SPLINE,
	OUTLINEMAT_COLOR_FACEANGLE_STRENGTH,

	OUTLINEMAT_COLOR_JOINANGLE,
	OUTLINEMAT_COLOR_JOINANGLE_SPLINE,
	OUTLINEMAT_COLOR_JOINANGLE_DIST,
	OUTLINEMAT_COLOR_JOINANGLE_STRENGTH,

	OUTLINEMAT_COLOR_SCREENANGLE,
	OUTLINEMAT_COLOR_SCREENANGLE_SPLINE,
	OUTLINEMAT_COLOR_SCREENANGLE_STRENGTH,

	OUTLINEMAT_COLOR_FROMEDGE,
	OUTLINEMAT_COLOR_FROMEDGE_SPLINE,
	OUTLINEMAT_COLOR_FROMEDGE_STRENGTH,

	OUTLINEMAT_COLOR_TEXTURE,
	OUTLINEMAT_COLOR_TEXTURE_LINK,
	OUTLINEMAT_COLOR_TEXTURE_STRENGTH,

	OUTLINEMAT_COLOR_POSITION,
	OUTLINEMAT_COLOR_POSITION_MIN,
	OUTLINEMAT_COLOR_POSITION_MAX,
	OUTLINEMAT_COLOR_POSITION_TYPE,
	OUTLINEMAT_COLOR_POSITION_SPLINE,
	OUTLINEMAT_COLOR_POSITION_STRENGTH,
	OUTLINEMAT_COLOR_POSITION_MODE,
	OUTLINEMAT_COLOR_POSITION_MODE_INVERT,

	OUTLINEMAT_COLOR_SCALE,
	OUTLINEMAT_COLOR_SCALE_TYPE,
	OUTLINEMAT_COLOR_SCALE_COORDS,
	OUTLINEMAT_COLOR_SCALE_SPLINE,
	OUTLINEMAT_COLOR_SCALE_STRENGTH,
	OUTLINEMAT_COLOR_SCALE_MODE,
	OUTLINEMAT_COLOR_SCALE_MODE_INVERT,
	OUTLINEMAT_COLOR_SCALE_MIN,
	OUTLINEMAT_COLOR_SCALE_MAX,

	OUTLINEMAT_COLOR_DISTANCE_OPMODE,
	OUTLINEMAT_COLOR_DISTANCE_MIX,
	OUTLINEMAT_COLOR_LENGTH_OPMODE,
	OUTLINEMAT_COLOR_LENGTH_MIX,
	OUTLINEMAT_COLOR_FACEANGLE_OPMODE,
	OUTLINEMAT_COLOR_FACEANGLE_MIX,
	OUTLINEMAT_COLOR_JOINANGLE_OPMODE,
	OUTLINEMAT_COLOR_JOINANGLE_MIX,
	OUTLINEMAT_COLOR_SCREENANGLE_OPMODE,
	OUTLINEMAT_COLOR_SCREENANGLE_MIX,
	OUTLINEMAT_COLOR_FROMEDGE_OPMODE,
	OUTLINEMAT_COLOR_FROMEDGE_MIX,
	OUTLINEMAT_COLOR_TEXTURE_OPMODE,
	OUTLINEMAT_COLOR_TEXTURE_MIX,
	OUTLINEMAT_COLOR_POSITION_OPMODE,
	OUTLINEMAT_COLOR_POSITION_MIX,
	OUTLINEMAT_COLOR_SCALE_OPMODE,
	OUTLINEMAT_COLOR_SCALE_MIX,
	OUTLINEMAT_COLOR_DUMMY,

	OUTLINEMAT_COLOR_ILLUMINATION,
	OUTLINEMAT_COLOR_ILLUMINATION_LIGHTS,
	OUTLINEMAT_COLOR_ILLUMINATION_LIGHT_MODE,
	OUTLINEMAT_COLOR_ILLUMINATION_MODE,
	OUTLINEMAT_COLOR_ILLUMINATION_STRENGTH,
	OUTLINEMAT_COLOR_ILLUMINATION_INVERT,
	OUTLINEMAT_COLOR_ILLUMINATION_SPLINE,
	OUTLINEMAT_COLOR_ILLUMINATION_OPMODE,
	OUTLINEMAT_COLOR_ILLUMINATION_USEMODE,
	OUTLINEMAT_COLOR_ILLUMINATION_BRIGHTNESS,

	OUTLINEMAT_COLOR_FROMSURFACE,
	OUTLINEMAT_COLOR_FROMSURFACE_OPMODE,
	OUTLINEMAT_COLOR_FROMSURFACE_STRENGTH,
	OUTLINEMAT_COLOR_FROMSURFACE_BRIGHTNESS,
	OUTLINEMAT_COLOR_FROMSURFACE_ILLUMINATION,
	OUTLINEMAT_COLOR_FROMSURFACE_SHADOWS,
	OUTLINEMAT_COLOR_FROMSURFACE_REFLECTIONS,
	OUTLINEMAT_COLOR_FROMSURFACE_TRANSPARENCY,

	OUTLINEMAT_COLOR_SCREENTEXTURE,
	OUTLINEMAT_COLOR_SCREENTEXTURE_LINK,
	OUTLINEMAT_COLOR_SCREENTEXTURE_STRENGTH,
	OUTLINEMAT_COLOR_SCREENTEXTURE_OFFX,
	OUTLINEMAT_COLOR_SCREENTEXTURE_OFFY,
	OUTLINEMAT_COLOR_SCREENTEXTURE_LENX,
	OUTLINEMAT_COLOR_SCREENTEXTURE_LENY,
	OUTLINEMAT_COLOR_SCREENTEXTURE_TILESX,
	OUTLINEMAT_COLOR_SCREENTEXTURE_TILESY,
	OUTLINEMAT_COLOR_SCREENTEXTURE_OPMODE,

	OUTLINEMAT_COLOR_CURVATURE,
	OUTLINEMAT_COLOR_CURVATURE_STRENGTH,
	OUTLINEMAT_COLOR_CURVATURE_SPLINE,
	OUTLINEMAT_COLOR_CURVATURE_OPMODE,

	OUTLINEMAT_COLOR_SLENGTH,
	OUTLINEMAT_COLOR_SLENGTH_STRENGTH,
	OUTLINEMAT_COLOR_SLENGTH_MIN,
	OUTLINEMAT_COLOR_SLENGTH_MAX,
	OUTLINEMAT_COLOR_SLENGTH_SPLINE,
	OUTLINEMAT_COLOR_SLENGTH_OPMODE,

	OUTLINEMAT_COLOR_COFFEE,
	OUTLINEMAT_COLOR_COFFEE_STRENGTH,
	OUTLINEMAT_COLOR_COFFEE_CODE,
	OUTLINEMAT_COLOR_COFFEE_ERROR,
	OUTLINEMAT_COLOR_COFFEE_CODEEDIT,
	OUTLINEMAT_COLOR_COFFEE_OPMODE,

	OUTLINEMAT_COLOR_TEXTURE_OFFSETX,
	OUTLINEMAT_COLOR_TEXTURE_OFFSETY,
	OUTLINEMAT_COLOR_TEXTURE_SCALEX,
	OUTLINEMAT_COLOR_TEXTURE_SCALEY,
	OUTLINEMAT_COLOR_TEXTURE_ASPECT,

	OUTLINEMAT_COLOR_BRIGHTNESS,

	OUTLINEMAT_ADV_BLENDMODE,
	OUTLINEMAT_ADV_SELFBLEND,
	OUTLINEMAT_ADV_BACKBLEND,
	OUTLINEMAT_ADV_SELFBLENDMODE,

	OUTLINEMAT_COLOR_NOISE_MAPPING,
	OUTLINEMAT_COLOR_NOISE_SCALE_X,
	OUTLINEMAT_COLOR_NOISE_SCALE_Y,
	OUTLINEMAT_COLOR_ANIMSPEED,
	OUTLINEMAT_COLOR_DETAIL,
	OUTLINEMAT_COLOR_LOW_CLIP,
	OUTLINEMAT_COLOR_HIGH_CLIP,
	OUTLINEMAT_COLOR_NOISE_BRIGHTNESS,
	OUTLINEMAT_COLOR_CONTRAST,
	OUTLINEMAT_COLOR_NOISE_ABS,
	OUTLINEMAT_COLOR_NOISE_INVERT,
	OUTLINEMAT_COLOR_CYCLES,
	OUTLINEMAT_COLOR_NOISE,
	OUTLINEMAT_COLOR_NOISE_TYPE,
	OUTLINEMAT_COLOR_NOISE_OCTAVES,
	OUTLINEMAT_COLOR_NOISE_STRENGTH,
	OUTLINEMAT_COLOR_NOISE_SCALE,
	OUTLINEMAT_COLOR_NOISE_MODE,
	OUTLINEMAT_COLOR_R_STRENGTH,
	OUTLINEMAT_COLOR_G_STRENGTH,
	OUTLINEMAT_COLOR_B_STRENGTH,
	OUTLINEMAT_COLOR_H_STRENGTH,
	OUTLINEMAT_COLOR_S_STRENGTH,
	OUTLINEMAT_COLOR_V_STRENGTH,

	OUTLINEMAT_COLOR_TEXTURE_SPACING,
	OUTLINEMAT_COLOR_TEXTURE_ROUND,
	OUTLINEMAT_COLOR_TEXTURE_ANGLE,
	OUTLINEMAT_COLOR_TEXTURE_SCATTER_U,
	OUTLINEMAT_COLOR_TEXTURE_SCATTER_V,
	OUTLINEMAT_COLOR_TEXTURE_SCATTER_COUNT,
	OUTLINEMAT_COLOR_TEXTURE_SCATTER_COUNT_VAR,
	OUTLINEMAT_COLOR_TEXTURE_ANGLE_VAR,
	OUTLINEMAT_COLOR_TEXTURE_ASPECT_VAR,
	OUTLINEMAT_COLOR_TEXTURE_SIZE,
	OUTLINEMAT_COLOR_TEXTURE_SIZE_VAR,
	OUTLINEMAT_COLOR_TEXTURE_TILING,
	OUTLINEMAT_COLOR_TEXTURE_BEND,
	OUTLINEMAT_COLOR_TEXTURE_ALPHA,	// DUMMY
	OUTLINEMAT_COLOR_TEXTUREALPHA_LINK,

	OUTLINEMAT_COLOR_MAP,
	OUTLINEMAT_COLOR_MAP_STRENGTH,
	OUTLINEMAT_COLOR_MAP_LINK,
	OUTLINEMAT_COLOR_MAP_OPMODE,
	OUTLINEMAT_COLOR_MAP_PROJECTION,
	OUTLINEMAT_COLOR_MAP_OFFX,
	OUTLINEMAT_COLOR_MAP_OFFY,
	OUTLINEMAT_COLOR_MAP_LENX,
	OUTLINEMAT_COLOR_MAP_LENY,

	OUTLINEMAT_COLOR_COFFEE_COMMANDS,
	OUTLINEMAT_COLOR_TEXTURE_LOAD,
	OUTLINEMAT_COLOR_TEXTURE_SAVE,

	OUTLINEMAT_COLOR_SCREENANGLE_ROTATE,
	OUTLINEMAT_COLOR_JOINANGLE_ENDS,

	//

	OUTLINEMAT_COLOR_TAB_END,	// DO NOT REMOVE OR CHANGE -- END MARKER --

	//

	OUTLINEMAT_MAP_PROJECTION_SPHERICAL = 0,
	OUTLINEMAT_MAP_PROJECTION_CYLINDRICAL,
	OUTLINEMAT_MAP_PROJECTION_FLAT,
	OUTLINEMAT_MAP_PROJECTION_CUBIC,
	OUTLINEMAT_MAP_PROJECTION_FRONTAL,
	OUTLINEMAT_MAP_PROJECTION_SPATIAL,
	OUTLINEMAT_MAP_PROJECTION_UVW,
	OUTLINEMAT_MAP_PROJECTION_SHRINKWRAP,

	OUTLINEMAT_COLOR_NOISE_MODE_RGB = 0,
	OUTLINEMAT_COLOR_NOISE_MODE_HSV,

	OUTLINEMAT_COLOR_NOISE_MAPPING_LINE1D = 0,
	OUTLINEMAT_COLOR_NOISE_MAPPING_LINE2D,
	OUTLINEMAT_COLOR_NOISE_MAPPING_SCREEN,
	OUTLINEMAT_COLOR_NOISE_MAPPING_OBJECT,
	OUTLINEMAT_COLOR_NOISE_MAPPING_WORLD,

	OUTLINEMAT_COLOR_MODE_ADD = 0,
	OUTLINEMAT_COLOR_MODE_SUB,
	OUTLINEMAT_COLOR_MODE_MULT,
	OUTLINEMAT_COLOR_MODE_NORMAL,

	OUTLINEMAT_MODIFIER_DISTANCE_RANGE_OBJECT = 0,
	OUTLINEMAT_MODIFIER_DISTANCE_RANGE_CAMERA,
	OUTLINEMAT_MODIFIER_DISTANCE_RANGE_USER,

	OUTLINEMAT_COLOR_DISTANCE_MODE_LINEAR = 0,
	OUTLINEMAT_COLOR_DISTANCE_MODE_SPLINE,

	OUTLINEMAT_COLOR_ILLUMINATION_LIGHT_MODE_INCLUDE = 0,
	OUTLINEMAT_COLOR_ILLUMINATION_LIGHT_MODE_EXCLUDE,

	OUTLINEMAT_COLOR_ILLUMINATION_MODE_LIGHT = 0,
	OUTLINEMAT_COLOR_ILLUMINATION_MODE_SHADOW,
	OUTLINEMAT_COLOR_ILLUMINATION_MODE_BOTH,

	OUTLINEMAT_COLOR_NOISE_TYPE_NOISE = 0,
	OUTLINEMAT_COLOR_NOISE_TYPE_SOFTTURBULENCE,
	OUTLINEMAT_COLOR_NOISE_TYPE_HARDTURBULENCE,
	OUTLINEMAT_COLOR_NOISE_TYPE_WAVYTURBULENCE,
	OUTLINEMAT_COLOR_NOISE_TYPE_RANDOM,

	OUTLINEMAT_COLOR_POSITION_TYPE_X = 0,
	OUTLINEMAT_COLOR_POSITION_TYPE_Y,
	OUTLINEMAT_COLOR_POSITION_TYPE_Z,

	OUTLINEMAT_COLOR_POSITION_MODE_LINEAR = 0,
	OUTLINEMAT_COLOR_POSITION_MODE_SPLINE,

	OUTLINEMAT_COLOR_SCALE_TYPE_X = 0,
	OUTLINEMAT_COLOR_SCALE_TYPE_Y,
	OUTLINEMAT_COLOR_SCALE_TYPE_Z,

	OUTLINEMAT_COLOR_SCALE_COORDS_WORLD = 0,
	OUTLINEMAT_COLOR_SCALE_COORDS_LOCAL,

	OUTLINEMAT_COLOR_SCALE_MODE_LINEAR = 0,
	OUTLINEMAT_COLOR_SCALE_MODE_SPLINE,

	OUTLINEMAT_COLOR_LENGTH_RANGE_LINE = 0,
	OUTLINEMAT_COLOR_LENGTH_RANGE_USER,

	OUTLINEMAT_COLOR_LENGTH_MODE_LINEAR = 0,
	OUTLINEMAT_COLOR_LENGTH_MODE_SPLINE,

//

	OUTLINEMAT_COLOR_ILLUMINATION_USEMODE_INTENSITY = 0,
	OUTLINEMAT_COLOR_ILLUMINATION_USEMODE_COLOR,

// THICKNESS

	OUTLINEMAT_THICKNESS_TAB_START = 60000,	// --- START MARKER ---

	//

	OUTLINEMAT_THICKNESS,

	OUTLINEMAT_THICKNESS_DISTANCE,
	OUTLINEMAT_THICKNESS_DISTANCE_MIN,
	OUTLINEMAT_THICKNESS_DISTANCE_MAX,
	OUTLINEMAT_THICKNESS_DISTANCE_SPLINE,
	OUTLINEMAT_THICKNESS_DISTANCE_STRENGTH,
	OUTLINEMAT_THICKNESS_DISTANCE_RANGE,
	OUTLINEMAT_THICKNESS_DISTANCE_MODE,
	OUTLINEMAT_THICKNESS_DISTANCE_MODE_INVERT,

	OUTLINEMAT_THICKNESS_LENGTH,
	OUTLINEMAT_THICKNESS_LENGTH_MIN,
	OUTLINEMAT_THICKNESS_LENGTH_MAX,
	OUTLINEMAT_THICKNESS_LENGTH_SPLINE,
	OUTLINEMAT_THICKNESS_LENGTH_LOOP,
	OUTLINEMAT_THICKNESS_LENGTH_STRENGTH,
	OUTLINEMAT_THICKNESS_LENGTH_RANGE,
	OUTLINEMAT_THICKNESS_LENGTH_MODE,
	OUTLINEMAT_THICKNESS_LENGTH_MODE_INVERT,

	OUTLINEMAT_THICKNESS_FACEANGLE,
	OUTLINEMAT_THICKNESS_FACEANGLE_SPLINE,
	OUTLINEMAT_THICKNESS_FACEANGLE_STRENGTH,

	OUTLINEMAT_THICKNESS_JOINANGLE,
	OUTLINEMAT_THICKNESS_JOINANGLE_SPLINE,
	OUTLINEMAT_THICKNESS_JOINANGLE_DIST,
	OUTLINEMAT_THICKNESS_JOINANGLE_STRENGTH,

	OUTLINEMAT_THICKNESS_SCREENANGLE,
	OUTLINEMAT_THICKNESS_SCREENANGLE_SPLINE,
	OUTLINEMAT_THICKNESS_SCREENANGLE_STRENGTH,


	OUTLINEMAT_THICKNESS_VERTEX,
	OUTLINEMAT_THICKNESS_VERTEX_STRENGTH,

	OUTLINEMAT_THICKNESS_ILLUMINATION,
	OUTLINEMAT_THICKNESS_ILLUMINATION_LIGHTS,
	OUTLINEMAT_THICKNESS_ILLUMINATION_LIGHT_MODE,
	OUTLINEMAT_THICKNESS_ILLUMINATION_MODE,
	OUTLINEMAT_THICKNESS_ILLUMINATION_STRENGTH,
	OUTLINEMAT_THICKNESS_ILLUMINATION_INVERT,

	OUTLINEMAT_THICKNESS_NOISE,
	OUTLINEMAT_THICKNESS_NOISE_TYPE,
	OUTLINEMAT_THICKNESS_NOISE_OCTAVES,
	OUTLINEMAT_THICKNESS_NOISE_STRENGTH,
	OUTLINEMAT_THICKNESS_NOISE_SCALE,

	OUTLINEMAT_THICKNESS_POSITION,
	OUTLINEMAT_THICKNESS_POSITION_MIN,
	OUTLINEMAT_THICKNESS_POSITION_MAX,
	OUTLINEMAT_THICKNESS_POSITION_TYPE,
	OUTLINEMAT_THICKNESS_POSITION_SPLINE,
	OUTLINEMAT_THICKNESS_POSITION_STRENGTH,
	OUTLINEMAT_THICKNESS_POSITION_MODE,
	OUTLINEMAT_THICKNESS_POSITION_MODE_INVERT,

	OUTLINEMAT_THICKNESS_SCALE,
	OUTLINEMAT_THICKNESS_SCALE_TYPE,
	OUTLINEMAT_THICKNESS_SCALE_COORDS,
	OUTLINEMAT_THICKNESS_SCALE_SPLINE,
	OUTLINEMAT_THICKNESS_SCALE_STRENGTH,
	OUTLINEMAT_THICKNESS_SCALE_MODE,
	OUTLINEMAT_THICKNESS_SCALE_MODE_INVERT,
	OUTLINEMAT_THICKNESS_SCALE_MIN,
	OUTLINEMAT_THICKNESS_SCALE_MAX,
	OUTLINEMAT_THICKNESS_SCALE_RANGE,

	OUTLINEMAT_THICKNESS_DUMMY,

	OUTLINEMAT_THICKNESS_SLENGTH,
	OUTLINEMAT_THICKNESS_SLENGTH_STRENGTH,
	OUTLINEMAT_THICKNESS_SLENGTH_MIN,
	OUTLINEMAT_THICKNESS_SLENGTH_MAX,
	OUTLINEMAT_THICKNESS_SLENGTH_SPLINE,

	OUTLINEMAT_THICKNESS_CURVATURE,
	OUTLINEMAT_THICKNESS_CURVATURE_STRENGTH,
	OUTLINEMAT_THICKNESS_CURVATURE_SPLINE,

	OUTLINEMAT_THICKNESS_SCREENTEXTURE,
	OUTLINEMAT_THICKNESS_SCREENTEXTURE_LINK,
	OUTLINEMAT_THICKNESS_SCREENTEXTURE_STRENGTH,
	OUTLINEMAT_THICKNESS_SCREENTEXTURE_OFFX,
	OUTLINEMAT_THICKNESS_SCREENTEXTURE_OFFY,
	OUTLINEMAT_THICKNESS_SCREENTEXTURE_LENX,
	OUTLINEMAT_THICKNESS_SCREENTEXTURE_LENY,
	OUTLINEMAT_THICKNESS_SCREENTEXTURE_TILESX,
	OUTLINEMAT_THICKNESS_SCREENTEXTURE_TILESY,

	OUTLINEMAT_THICKNESS_ANIMSPEED,
	OUTLINEMAT_THICKNESS_DETAIL,
	OUTLINEMAT_THICKNESS_LOW_CLIP,
	OUTLINEMAT_THICKNESS_HIGH_CLIP,
	OUTLINEMAT_THICKNESS_BRIGHTNESS,
	OUTLINEMAT_THICKNESS_CONTRAST,
	OUTLINEMAT_THICKNESS_NOISE_ABS,
	OUTLINEMAT_THICKNESS_NOISE_INVERT,

	OUTLINEMAT_THICKNESS_COFFEE,
	OUTLINEMAT_THICKNESS_COFFEE_STRENGTH,
	OUTLINEMAT_THICKNESS_COFFEE_CODE,
	OUTLINEMAT_THICKNESS_COFFEE_ERROR,
	OUTLINEMAT_THICKNESS_COFFEE_CODEEDIT,

	OUTLINEMAT_THICKNESS_NOISE_MAPPING,

	OUTLINEMAT_THICKNESS_MAP,
	OUTLINEMAT_THICKNESS_MAP_STRENGTH,
	OUTLINEMAT_THICKNESS_MAP_LINK,
	OUTLINEMAT_THICKNESS_MAP_PROJECTION,
	OUTLINEMAT_THICKNESS_MAP_OFFX,
	OUTLINEMAT_THICKNESS_MAP_OFFY,
	OUTLINEMAT_THICKNESS_MAP_LENX,
	OUTLINEMAT_THICKNESS_MAP_LENY,

	OUTLINEMAT_THICKNESS_COFFEE_COMMANDS,

	OUTLINEMAT_THICKNESS_SCREENANGLE_ROTATE,
	OUTLINEMAT_THICKNESS_JOINANGLE_ENDS,
	OUTLINEMAT_THICKNESS_ILLUMINATION_SPLINE,

	//

	OUTLINEMAT_THICKNESS_TAB_END,	// DO NOT REMOVE OR CHANGE -- END MARKER --

	//

	OUTLINEMAT_JOINANGLE_ENDS_OFF = 0,
	OUTLINEMAT_JOINANGLE_ENDS_MIN,
	OUTLINEMAT_JOINANGLE_ENDS_ZERO,
	OUTLINEMAT_JOINANGLE_ENDS_MAX,

	OUTLINEMAT_THICKNESS_NOISE_MAPPING_LINE = 0,
	OUTLINEMAT_THICKNESS_NOISE_MAPPING_SCREEN,
	OUTLINEMAT_THICKNESS_NOISE_MAPPING_OBJECT,
	OUTLINEMAT_THICKNESS_NOISE_MAPPING_WORLD,

	OUTLINEMAT_THICKNESS_DISTANCE_MODE_LINEAR = 0,
	OUTLINEMAT_THICKNESS_DISTANCE_MODE_SPLINE,

	OUTLINEMAT_THICKNESS_ILLUMINATION_LIGHT_MODE_INCLUDE = 0,
	OUTLINEMAT_THICKNESS_ILLUMINATION_LIGHT_MODE_EXCLUDE,

	OUTLINEMAT_THICKNESS_ILLUMINATION_MODE_LIGHT = 0,
	OUTLINEMAT_THICKNESS_ILLUMINATION_MODE_SHADOW,
	OUTLINEMAT_THICKNESS_ILLUMINATION_MODE_BOTH,

	OUTLINEMAT_THICKNESS_POSITION_TYPE_X = 0,
	OUTLINEMAT_THICKNESS_POSITION_TYPE_Y,
	OUTLINEMAT_THICKNESS_POSITION_TYPE_Z,

	OUTLINEMAT_THICKNESS_POSITION_MODE_LINEAR = 0,
	OUTLINEMAT_THICKNESS_POSITION_MODE_SPLINE,

	OUTLINEMAT_THICKNESS_SCALE_TYPE_X = 0,
	OUTLINEMAT_THICKNESS_SCALE_TYPE_Y,
	OUTLINEMAT_THICKNESS_SCALE_TYPE_Z,

	OUTLINEMAT_THICKNESS_SCALE_COORDS_WORLD = 0,
	OUTLINEMAT_THICKNESS_SCALE_COORDS_LOCAL,

	OUTLINEMAT_THICKNESS_SCALE_MODE_LINEAR = 0,
	OUTLINEMAT_THICKNESS_SCALE_MODE_SPLINE,

	OUTLINEMAT_THICKNESS_SCALE_RANGE_SCALE = 0,
	OUTLINEMAT_THICKNESS_SCALE_RANGE_USER,

	OUTLINEMAT_THICKNESS_LENGTH_RANGE_LINE = 0,
	OUTLINEMAT_THICKNESS_LENGTH_RANGE_USER,

	OUTLINEMAT_THICKNESS_LENGTH_MODE_LINEAR = 0,
	OUTLINEMAT_THICKNESS_LENGTH_MODE_SPLINE,

// OPACITY

	OUTLINEMAT_OPACITY_TAB_START = 70000,	// --- START MARKER ---

	//

	OUTLINEMAT_OPACITY,

	OUTLINEMAT_OPACITY_DISTANCE,
	OUTLINEMAT_OPACITY_DISTANCE_MIN,
	OUTLINEMAT_OPACITY_DISTANCE_MAX,
	OUTLINEMAT_OPACITY_DISTANCE_SPLINE,
	OUTLINEMAT_OPACITY_DISTANCE_STRENGTH,
	OUTLINEMAT_OPACITY_DISTANCE_RANGE,
	OUTLINEMAT_OPACITY_DISTANCE_MODE,
	OUTLINEMAT_OPACITY_DISTANCE_MODE_INVERT,

	OUTLINEMAT_OPACITY_LENGTH,
	OUTLINEMAT_OPACITY_LENGTH_MIN,
	OUTLINEMAT_OPACITY_LENGTH_MAX,
	OUTLINEMAT_OPACITY_LENGTH_SPLINE,
	OUTLINEMAT_OPACITY_LENGTH_LOOP,
	OUTLINEMAT_OPACITY_LENGTH_STRENGTH,
	OUTLINEMAT_OPACITY_LENGTH_RANGE,
	OUTLINEMAT_OPACITY_LENGTH_MODE,
	OUTLINEMAT_OPACITY_LENGTH_MODE_INVERT,

	OUTLINEMAT_OPACITY_FACEANGLE,
	OUTLINEMAT_OPACITY_FACEANGLE_SPLINE,
	OUTLINEMAT_OPACITY_FACEANGLE_STRENGTH,

	OUTLINEMAT_OPACITY_JOINANGLE,
	OUTLINEMAT_OPACITY_JOINANGLE_SPLINE,
	OUTLINEMAT_OPACITY_JOINANGLE_DIST,
	OUTLINEMAT_OPACITY_JOINANGLE_STRENGTH,

	OUTLINEMAT_OPACITY_SCREENANGLE,
	OUTLINEMAT_OPACITY_SCREENANGLE_SPLINE,
	OUTLINEMAT_OPACITY_SCREENANGLE_STRENGTH,

	OUTLINEMAT_OPACITY_FROMEDGE,
	OUTLINEMAT_OPACITY_FROMEDGE_SPLINE,
	OUTLINEMAT_OPACITY_FROMEDGE_STRENGTH,

	OUTLINEMAT_OPACITY_TEXTURE,
	OUTLINEMAT_OPACITY_TEXTURE_LINK,
	OUTLINEMAT_OPACITY_TEXTURE_STRENGTH,

	OUTLINEMAT_OPACITY_VERTEX,
	OUTLINEMAT_OPACITY_VERTEX_STRENGTH,

	OUTLINEMAT_OPACITY_ILLUMINATION,
	OUTLINEMAT_OPACITY_ILLUMINATION_LIGHTS,
	OUTLINEMAT_OPACITY_ILLUMINATION_LIGHT_MODE,
	OUTLINEMAT_OPACITY_ILLUMINATION_MODE,
	OUTLINEMAT_OPACITY_ILLUMINATION_STRENGTH,
	OUTLINEMAT_OPACITY_ILLUMINATION_INVERT,

	OUTLINEMAT_OPACITY_NOISE,
	OUTLINEMAT_OPACITY_NOISE_TYPE,
	OUTLINEMAT_OPACITY_NOISE_OCTAVES,
	OUTLINEMAT_OPACITY_NOISE_STRENGTH,
	OUTLINEMAT_OPACITY_NOISE_SCALE,

	OUTLINEMAT_OPACITY_POSITION,
	OUTLINEMAT_OPACITY_POSITION_MIN,
	OUTLINEMAT_OPACITY_POSITION_MAX,
	OUTLINEMAT_OPACITY_POSITION_TYPE,
	OUTLINEMAT_OPACITY_POSITION_SPLINE,
	OUTLINEMAT_OPACITY_POSITION_STRENGTH,
	OUTLINEMAT_OPACITY_POSITION_MODE,
	OUTLINEMAT_OPACITY_POSITION_MODE_INVERT,

	OUTLINEMAT_OPACITY_SCALE,
	OUTLINEMAT_OPACITY_SCALE_TYPE,
	OUTLINEMAT_OPACITY_SCALE_COORDS,
	OUTLINEMAT_OPACITY_SCALE_SPLINE,
	OUTLINEMAT_OPACITY_SCALE_STRENGTH,
	OUTLINEMAT_OPACITY_SCALE_MODE,
	OUTLINEMAT_OPACITY_SCALE_MODE_INVERT,
	OUTLINEMAT_OPACITY_SCALE_MIN,
	OUTLINEMAT_OPACITY_SCALE_MAX,
	OUTLINEMAT_OPACITY_SCALE_RANGE,

	OUTLINEMAT_OPACITY_DUMMY,

	OUTLINEMAT_OPACITY_SCREENTEXTURE,
	OUTLINEMAT_OPACITY_SCREENTEXTURE_LINK,
	OUTLINEMAT_OPACITY_SCREENTEXTURE_STRENGTH,
	OUTLINEMAT_OPACITY_SCREENTEXTURE_OFFX,
	OUTLINEMAT_OPACITY_SCREENTEXTURE_OFFY,
	OUTLINEMAT_OPACITY_SCREENTEXTURE_LENX,
	OUTLINEMAT_OPACITY_SCREENTEXTURE_LENY,
	OUTLINEMAT_OPACITY_SCREENTEXTURE_TILESX,
	OUTLINEMAT_OPACITY_SCREENTEXTURE_TILESY,

	OUTLINEMAT_OPACITY_SLENGTH,
	OUTLINEMAT_OPACITY_SLENGTH_STRENGTH,
	OUTLINEMAT_OPACITY_SLENGTH_MIN,
	OUTLINEMAT_OPACITY_SLENGTH_MAX,
	OUTLINEMAT_OPACITY_SLENGTH_SPLINE,

	OUTLINEMAT_OPACITY_LINKTHICKNESS,

	OUTLINEMAT_OPACITY_CURVATURE,
	OUTLINEMAT_OPACITY_CURVATURE_STRENGTH,
	OUTLINEMAT_OPACITY_CURVATURE_SPLINE,

	OUTLINEMAT_OPACITY_NOISE_SCALE_X,
	OUTLINEMAT_OPACITY_NOISE_SCALE_Y,
	OUTLINEMAT_OPACITY_ANIMSPEED,
	OUTLINEMAT_OPACITY_DETAIL,
	OUTLINEMAT_OPACITY_LOW_CLIP,
	OUTLINEMAT_OPACITY_HIGH_CLIP,
	OUTLINEMAT_OPACITY_BRIGHTNESS,
	OUTLINEMAT_OPACITY_CONTRAST,
	OUTLINEMAT_OPACITY_NOISE_ABS,
	OUTLINEMAT_OPACITY_NOISE_INVERT,
	OUTLINEMAT_OPACITY_CYCLES,

	OUTLINEMAT_OPACITY_COFFEE,
	OUTLINEMAT_OPACITY_COFFEE_STRENGTH,
	OUTLINEMAT_OPACITY_COFFEE_CODE,
	OUTLINEMAT_OPACITY_COFFEE_ERROR,
	OUTLINEMAT_OPACITY_COFFEE_CODEEDIT,

	OUTLINEMAT_OPACITY_TEXTURE_OFFSETX,
	OUTLINEMAT_OPACITY_TEXTURE_OFFSETY,
	OUTLINEMAT_OPACITY_TEXTURE_SCALEX,
	OUTLINEMAT_OPACITY_TEXTURE_SCALEY,
	OUTLINEMAT_OPACITY_TEXTURE_ASPECT,

	OUTLINEMAT_OPACITY_NOISE_MAPPING,
	OUTLINEMAT_OPACITY_TEXTURE_INVERT,
	OUTLINEMAT_OPACITY_TEXTURE_SPACING,
	OUTLINEMAT_OPACITY_TEXTURE_ROUND,
	OUTLINEMAT_OPACITY_TEXTURE_ANGLE,
	OUTLINEMAT_OPACITY_TEXTURE_SCATTER_U,
	OUTLINEMAT_OPACITY_TEXTURE_SCATTER_V,
	OUTLINEMAT_OPACITY_TEXTURE_SCATTER_COUNT,
	OUTLINEMAT_OPACITY_TEXTURE_SCATTER_COUNT_VAR,
	OUTLINEMAT_OPACITY_TEXTURE_ANGLE_VAR,
	OUTLINEMAT_OPACITY_TEXTURE_ASPECT_VAR,
	OUTLINEMAT_OPACITY_TEXTURE_SIZE,
	OUTLINEMAT_OPACITY_TEXTURE_SIZE_VAR,
	OUTLINEMAT_OPACITY_TEXTURE_TILING,
	OUTLINEMAT_OPACITY_TEXTURE_BEND,

	OUTLINEMAT_OPACITY_MAP,
	OUTLINEMAT_OPACITY_MAP_STRENGTH,
	OUTLINEMAT_OPACITY_MAP_LINK,
	OUTLINEMAT_OPACITY_MAP_PROJECTION,
	OUTLINEMAT_OPACITY_MAP_OFFX,
	OUTLINEMAT_OPACITY_MAP_OFFY,
	OUTLINEMAT_OPACITY_MAP_LENX,
	OUTLINEMAT_OPACITY_MAP_LENY,

	OUTLINEMAT_OPACITY_COFFEE_COMMANDS,
	OUTLINEMAT_OPACITY_TEXTURE_LOAD,
	OUTLINEMAT_OPACITY_TEXTURE_SAVE,

	OUTLINEMAT_OPACITY_SCREENANGLE_ROTATE,
	OUTLINEMAT_OPACITY_JOINANGLE_ENDS,
	OUTLINEMAT_OPACITY_ILLUMINATION_SPLINE,

	//

	OUTLINEMAT_OPACITY_TAB_END,	// DO NOT REMOVE OR CHANGE -- END MARKER --

	//

	OUTLINEMAT_OPACITY_NOISE_MAPPING_LINE1D = 0,
	OUTLINEMAT_OPACITY_NOISE_MAPPING_LINE2D,
	OUTLINEMAT_OPACITY_NOISE_MAPPING_SCREEN,
	OUTLINEMAT_OPACITY_NOISE_MAPPING_OBJECT,
	OUTLINEMAT_OPACITY_NOISE_MAPPING_WORLD,

	OUTLINEMAT_OPACITY_DISTANCE_MODE_LINEAR = 0,
	OUTLINEMAT_OPACITY_DISTANCE_MODE_SPLINE,

	OUTLINEMAT_OPACITY_ILLUMINATION_LIGHT_MODE_INCLUDE = 0,
	OUTLINEMAT_OPACITY_ILLUMINATION_LIGHT_MODE_EXCLUDE,

	OUTLINEMAT_OPACITY_ILLUMINATION_MODE_LIGHT = 0,
	OUTLINEMAT_OPACITY_ILLUMINATION_MODE_SHADOW,
	OUTLINEMAT_OPACITY_ILLUMINATION_MODE_BOTH,

	OUTLINEMAT_OPACITY_POSITION_TYPE_X = 0,
	OUTLINEMAT_OPACITY_POSITION_TYPE_Y,
	OUTLINEMAT_OPACITY_POSITION_TYPE_Z,

	OUTLINEMAT_OPACITY_POSITION_MODE_LINEAR = 0,
	OUTLINEMAT_OPACITY_POSITION_MODE_SPLINE,

	OUTLINEMAT_OPACITY_SCALE_TYPE_X = 0,
	OUTLINEMAT_OPACITY_SCALE_TYPE_Y,
	OUTLINEMAT_OPACITY_SCALE_TYPE_Z,

	OUTLINEMAT_OPACITY_SCALE_COORDS_WORLD = 0,
	OUTLINEMAT_OPACITY_SCALE_COORDS_LOCAL,

	OUTLINEMAT_OPACITY_SCALE_MODE_LINEAR = 0,
	OUTLINEMAT_OPACITY_SCALE_MODE_SPLINE,

	OUTLINEMAT_OPACITY_SCALE_RANGE_SCALE = 0,
	OUTLINEMAT_OPACITY_SCALE_RANGE_USER,

	OUTLINEMAT_OPACITY_LENGTH_RANGE_LINE = 0,
	OUTLINEMAT_OPACITY_LENGTH_RANGE_USER,

	OUTLINEMAT_OPACITY_LENGTH_MODE_LINEAR = 0,
	OUTLINEMAT_OPACITY_LENGTH_MODE_SPLINE,

// RENDER

	OUTLINEMAT_RENDER_TAB_START = 80000,	// --- START MARKER ---

	//

	OUTLINEMAT_SCENE_TOONALL,
	OUTLINEMAT_SCENE_AA,

	OUTLINEMAT_SCENE_INEX_MODE,
	OUTLINEMAT_SCENE_INEXCLUDE,

	OUTLINEMAT_LINE_RENDERCLIP,

	OUTLINEMAT_STOKECLIP_TOSCREEN,

	OUTLINEMAT_CAMERACLIP_MINZ,
	OUTLINEMAT_CAMERACLIP_MAXZ,

	OUTLINEMAT_PIXELUNITS_INDEPENDENT,
	OUTLINEMAT_PIXELUNITS_BASEW,
	OUTLINEMAT_PIXELUNITS_BASEH,
	OUTLINEMAT_PIXELUNITS_ASEDITOR,
	OUTLINEMAT_PIXELUNITS_ASRENDER,
	OUTLINEMAT_PIXELUNITS_INDEPENDENT_MODE,

	OUTLINEMAT_SCENE_DUMMY_1,
	OUTLINEMAT_SCENE_DUMMY_2,
	OUTLINEMAT_SCENE_DUMMY_3,
	OUTLINEMAT_SCENE_DUMMY_4,

	OUTLINEMAT_SCENE_SEED,
	OUTLINEMAT_SCENE_SEED_STATIC,
	OUTLINEMAT_SCENE_SCALE,

	OUTLINEMAT_SCENE_POSTRENDER,
	OUTLINEMAT_SCENE_VOLUMETRIC,
	OUTLINEMAT_CAMERACLIP_FAR,

	OUTLINEMAT_LINE_RENDERCLIP_SELF,
	OUTLINEMAT_SCENE_PIXELUNITS,
	OUTLINEMAT_LINE_RENDERCLIP_MODE,
	OUTLINEMAT_LINE_RENDERCLIP_OBJECTS,

	OUTLINEMAT_LINE_RENDERCULL_TYPE,
	OUTLINEMAT_LINE_RENDERCULL_MODE,
	OUTLINEMAT_LINE_RENDERCULL_SELF,
	OUTLINEMAT_LINE_RENDERCULL_OBJECTS,
	OUTLINEMAT_LINE_RENDERCULL_QUALITY,

	//

	OUTLINEMAT_RENDER_TAB_END,	// DO NOT REMOVE OR CHANGE -- END MARKER --

	//

	OUTLINEMAT_LINE_RENDERCULL_TYPE_VISIBLE = 0,
	OUTLINEMAT_LINE_RENDERCULL_TYPE_HIDDEN,

	OUTLINEMAT_LINE_RENDERCULL_MODE_SELF = 0,
	OUTLINEMAT_LINE_RENDERCULL_MODE_WITHCHILD,
	OUTLINEMAT_LINE_RENDERCULL_MODE_HIERARCHY,
	OUTLINEMAT_LINE_RENDERCULL_MODE_SCENE,
	OUTLINEMAT_LINE_RENDERCULL_MODE_OBJECTS,

	OUTLINEMAT_LINE_RENDERCLIP_MODE_SELF = 0,
	OUTLINEMAT_LINE_RENDERCLIP_MODE_WITHCHILD,
	OUTLINEMAT_LINE_RENDERCLIP_MODE_HIERARCHY,
	OUTLINEMAT_LINE_RENDERCLIP_MODE_SCENE,
	OUTLINEMAT_LINE_RENDERCLIP_MODE_OBJECTS,

	OUTLINEMAT_SCENE_PIXELUNITS_ABSPIXELS = 0,
	OUTLINEMAT_SCENE_PIXELUNITS_RELPIXELS,
	OUTLINEMAT_SCENE_PIXELUNITS_WORLD,

	OUTLINEMAT_PIXELUNITS_INDEPENDENT_MODE_RENDER = 0,
	OUTLINEMAT_PIXELUNITS_INDEPENDENT_MODE_CUSTOM,

	OUTLINEMAT_SCENE_AA_OFF = 0,
	OUTLINEMAT_SCENE_AA_1,
	OUTLINEMAT_SCENE_AA_2,
	OUTLINEMAT_SCENE_AA_3,
	OUTLINEMAT_SCENE_AA_4,

	OUTLINEMAT_SCENE_INEX_MODE_INCLUDE = 0,
	OUTLINEMAT_SCENE_INEX_MODE_EXCLUDE,

// CLONE

	OUTLINEMAT_CLONE_TAB_START = 90000,	// --- START MARKER ---

	//

	OUTLINEMAT_CLONE_THICKNESS_VAR,
	OUTLINEMAT_CLONE_OPACITY_VAR,
	OUTLINEMAT_CLONE_OFFSET_VAR,
	OUTLINEMAT_CLONE_OVERSHOOT_VAR,
	OUTLINEMAT_CLONE_SCALE_VAR,
	OUTLINEMAT_CLONE_ROTATE_VAR,
	OUTLINEMAT_CLONE_COLOUR_H_VAR,
	OUTLINEMAT_CLONE_COLOUR_S_VAR,
	OUTLINEMAT_CLONE_COLOUR_V_VAR,
	OUTLINEMAT_CLONE_INCREMENTAL,
	OUTLINEMAT_CLONE_CLONESCALE_X,
	OUTLINEMAT_CLONE_CLONESCALE_X_VAR,
	OUTLINEMAT_CLONE_CLONESCALE_Y,
	OUTLINEMAT_CLONE_CLONESCALE_Y_VAR,
	OUTLINEMAT_CLONE_CLONEROTATE_X,
	OUTLINEMAT_CLONE_CLONEROTATE_X_VAR,
	OUTLINEMAT_CLONE_STROKE_START,
	OUTLINEMAT_CLONE_STROKE_START_VAR,
	OUTLINEMAT_CLONE_STROKE_END,
	OUTLINEMAT_CLONE_STROKE_END_VAR,
	OUTLINEMAT_CLONE_BLENDMODE,
	OUTLINEMAT_CLONE_REPEAT,
	OUTLINEMAT_CLONE_ENABLE,
	OUTLINEMAT_CLONE_CLONEMOVE_X,
	OUTLINEMAT_CLONE_CLONEMOVE_X_VAR,
	OUTLINEMAT_CLONE_CLONEMOVE_Y,
	OUTLINEMAT_CLONE_CLONEMOVE_Y_VAR,
	OUTLINEMAT_CLONE_THICKNESS,
	OUTLINEMAT_CLONE_OPACITY,
	OUTLINEMAT_CLONE_PIVOT,
	OUTLINEMAT_CLONE_NOISE_VAR,
	OUTLINEMAT_CLONE_NOISEOFF_VAR,
	OUTLINEMAT_CLONE_LINE_OFFSET,
	OUTLINEMAT_CLONE_METHOD,

	//

	OUTLINEMAT_CLONE_TAB_END,	// DO NOT REMOVE OR CHANGE -- END MARKER --

	OUTLINEMAT_CLONE_METHOD_UNIFORM = 0,
	OUTLINEMAT_CLONE_METHOD_GAUSSIAN,

// ANIMATE

	OUTLINEMAT_ANIM_TAB_START = 100000,	// --- START MARKER ---

	//

	OUTLINEMAT_ANIMATE_AUTODRAW,
	OUTLINEMAT_ANIMATE_STROKES,
	OUTLINEMAT_ANIMATE_STROKES_DUMMY,
	OUTLINEMAT_ANIMATE_STROKES_COUNT,
	OUTLINEMAT_ANIMATE_STROKE_SPEED,
	OUTLINEMAT_ANIMATE_STROKE_MODE,
	OUTLINEMAT_ANIMATE_START,
	OUTLINEMAT_ANIMATE_STROKE_METHOD,
	OUTLINEMAT_ANIMATE_STROKE_SPEED_TYPE,
	OUTLINEMAT_ANIMATE_STROKE_TIME,
	OUTLINEMAT_ANIMATE_STROKE_SPEED_COMPLETE,
	OUTLINEMAT_ANIMATE_END,

	//

	OUTLINEMAT_ANIM_TAB_END,	// DO NOT REMOVE OR CHANGE -- END MARKER --

	//

	OUTLINEMAT_ANIMATE_STROKE_METHOD_SINGLE = 0,
	OUTLINEMAT_ANIMATE_STROKE_METHOD_ALL,

	OUTLINEMAT_ANIMATE_STROKE_SPEED_TYPE_PIXELS_LENGTH = 0,
	OUTLINEMAT_ANIMATE_STROKE_SPEED_TYPE_TIME,
	OUTLINEMAT_ANIMATE_STROKE_SPEED_TYPE_COMPLETION,
	OUTLINEMAT_ANIMATE_STROKE_SPEED_TYPE_TOTALTIME,
	OUTLINEMAT_ANIMATE_STROKE_SPEED_TYPE_ENDFRAME,
	OUTLINEMAT_ANIMATE_STROKE_SPEED_TYPE_ANIMEND,

// SHADING TAB

	OUTLINEMAT_SHADING_TAB_START = 120000,	// --- START MARKER ---

	OUTLINEMAT_SHADING_BACK,
	OUTLINEMAT_SHADING_BACK_COL,
	OUTLINEMAT_SHADING_BACK_TEX,
	OUTLINEMAT_SHADING_OBJECT,
	OUTLINEMAT_SHADING_OBJECT_COL,
	OUTLINEMAT_SHADING_OBJECT_TEX,
	OUTLINEMAT_SHADING_OBJECT_MODEL,
	OUTLINEMAT_SHADING_QUANTISE_LEVEL,
	OUTLINEMAT_SHADING_GRADQUANT,
	OUTLINEMAT_SHADING_ILLUMINATION,
	OUTLINEMAT_SHADING_SHADOWS,
	OUTLINEMAT_SHADING_REFLECTIONS,
	OUTLINEMAT_SHADING_TRANSPARENCY,
	OUTLINEMAT_SHADING_SHADOW_COL,
	OUTLINEMAT_SHADING_SHADOW_COLORIZE,
	OUTLINEMAT_SHADING_SHADOW_COL_STRENGTH,
	OUTLINEMAT_SHADING_INEX_MODE,
	OUTLINEMAT_SHADING_INEXCLUDE,
	OUTLINEMAT_SHADING_ALLTOON,
	OUTLINEMAT_SHADING_OBJECT_DUMMY,
	OUTLINEMAT_SHADING_ENABLE,
	OUTLINEMAT_SHADING_BACK_ALPHA,
	OUTLINEMAT_SHADING_BACK_ALPHA_STRENGTH,
	OUTLINEMAT_SHADING_BACK_TEX_ALPHA,
	OUTLINEMAT_SHADING_BACK_ALPHALINES,
	OUTLINEMAT_SHADING_BACK_ALPHAOBJECTS,

	OUTLINEMAT_SHADING_TAB_END,	// DO NOT REMOVE OR CHANGE -- END MARKER --

	//

	OUTLINEMAT_SHADING_INEX_MODE_INCLUDE = 0,
	OUTLINEMAT_SHADING_INEX_MODE_EXCLUDE,

	OUTLINEMAT_SHADING_BACK_CINEMA = 0,
	OUTLINEMAT_SHADING_BACK_COLOR,
	OUTLINEMAT_SHADING_BACK_TEXTURE,

	OUTLINEMAT_SHADING_OBJECT_CINEMA = 0,
	OUTLINEMAT_SHADING_OBJECT_COLOR_DISPLAY,
	OUTLINEMAT_SHADING_OBJECT_COLOR_USER,
	OUTLINEMAT_SHADING_OBJECT_TEXTURE,
	OUTLINEMAT_SHADING_OBJECT_BACKGROUND,
	OUTLINEMAT_SHADING_OBJECT_SHADED,

	OUTLINEMAT_SHADING_OBJECT_MODEL_QUANTISE = 0,
	OUTLINEMAT_SHADING_OBJECT_MODEL_GRADQUANT,

// MULTIPASS


	OUTLINEMAT_MULTIPASS_TAB_START = 130000,	// --- START MARKER ---

	//

	OUTLINEMAT_MULTIPASS_SPLITTYPES,
	OUTLINEMAT_MULTIPASS_RGB,
	OUTLINEMAT_MULTIPASS_DEPTH,
	OUTLINEMAT_MULTIPASS_ALPHA,
	OUTLINEMAT_MULTIPASS_LINE_OUTLINE,
	OUTLINEMAT_MULTIPASS_LINE_FOLD,
	OUTLINEMAT_MULTIPASS_LINE_OVERLAPS,
	OUTLINEMAT_MULTIPASS_LINE_CREASE,
	OUTLINEMAT_MULTIPASS_LINE_ANGLE,
	OUTLINEMAT_MULTIPASS_LINE_BORDER,
	OUTLINEMAT_MULTIPASS_LINE_MATERIAL,
	OUTLINEMAT_MULTIPASS_LINE_EDGES,
	OUTLINEMAT_MULTIPASS_LINE_INTERSECTION,
	OUTLINEMAT_MULTIPASS_LINE_ZDELTA,
	OUTLINEMAT_MULTIPASS_LINE_TRI,
	OUTLINEMAT_MULTIPASS_LINE_MOTION,
	OUTLINEMAT_MULTIPASS_LINE_CONTOUR,
	OUTLINEMAT_MULTIPASS_LINE_ISOPARMS,
	OUTLINEMAT_MULTIPASS_LINE_SPLINES,
	OUTLINEMAT_MULTIPASS_LINE_PARTICLES,
	OUTLINEMAT_MULTIPASS_SPLITSHOW,

	//

	OUTLINEMAT_MULTIPASS_TAB_END,

// EDITOR LINES


	OUTLINEMAT_EDLINES_TAB_START = 140000,	// --- START MARKER ---

	//

	OUTLINEMAT_EDLINES_SHOWLINES,

	OUTLINEMAT_EDLINES_LINE_OBJECTS,
	OUTLINEMAT_EDLINES_LINE_OBJECTS_MODE,

	OUTLINEMAT_EDLINES_LINE_OUTLINE,
	OUTLINEMAT_EDLINES_LINE_FOLD,
	OUTLINEMAT_EDLINES_LINE_OVERLAPS,
	OUTLINEMAT_EDLINES_LINE_MATERIAL,
	OUTLINEMAT_EDLINES_LINE_CREASE,
	OUTLINEMAT_EDLINES_LINE_INTERSECTION,
	OUTLINEMAT_EDLINES_LINE_BORDER,
	OUTLINEMAT_EDLINES_LINE_EDGES,
	OUTLINEMAT_EDLINES_LINE_ANGLE,
	OUTLINEMAT_EDLINES_LINE_CONTOUR,
	OUTLINEMAT_EDLINES_LINE_ISOPARMS,
	OUTLINEMAT_EDLINES_LINE_TRI,
	OUTLINEMAT_EDLINES_LINE_SPLINES,
	OUTLINEMAT_EDLINES_LINE_PARTICLES,
	OUTLINEMAT_EDLINES_LINE_MOTION,
	OUTLINEMAT_EDLINES_LINE_SMOOTH,
	OUTLINEMAT_EDLINES_LINE_ZDELTA,

	OUTLINEMAT_EDLINES_LINE_SHOWCOLOR,
	OUTLINEMAT_EDLINES_LINE_SHOWTHICKNESS,
	OUTLINEMAT_EDLINES_LINE_COLOR,
	OUTLINEMAT_EDLINES_LINE_THICKNESS,
	OUTLINEMAT_EDLINES_LINE_DRAW,

	OUTLINEMAT_EDLINES_REDRAW_FULL,

	//

	OUTLINEMAT_EDLINES_TAB_END,

	//

	OUTLINEMAT_EDLINES_LINE_OBJECTS_INCLUDE = 0,
	OUTLINEMAT_EDLINES_LINE_OBJECTS_EXCLUDE,
	OUTLINEMAT_EDLINES_LINE_OBJECTS_ACTIVEONLY,

	OUTLINEMAT_EDLINES_LINE_DRAW_2D = 0,
	OUTLINEMAT_EDLINES_LINE_DRAW_3D,

// MATERIAL OPTIONS

	OUTLINEMAT_MATERIAL_START = 200000,

	//

	OUTLINEMAT_PREVIEW_BACKGROUND,
	OUTLINEMAT_PREVIEW_OBJECT,

	OUTLINEMAT_USER_LEVEL =  200010,	// TOONUP_PREFS_USER_LEVEL

	OUTLINEMAT_PRESET  =  200011,
	OUTLINEMAT_PRESET_ADD,
	OUTLINEMAT_MATERIALS,
	OUTLINEMAT_VP_DUMMY,

	OUTLINEMAT_ASSIGN,
	OUTLINEMAT_PRIORITY,

	//

	OUTLINEMAT_MATERIAL_END,

	//

	OUTLINEMAT_PRESET_DEFAULTS = 0,

	OUTLINEMAT_USER_LEVEL_BASIC = 0,
	OUTLINEMAT_USER_LEVEL_MEDIUM,
	OUTLINEMAT_USER_LEVEL_ADVANCED,

// RESERVED FOR MATERIAL/TAG/EXTRAS

	OUTLINEMAT_EXTERN_START = 300000,
	OUTLINEMAT_EXTERN_END = 399999,

// RESERVED FOR TEXTURE TAG

	OUTLINEMAT_EXTERN_TTAG_START = 400000,
	OUTLINEMAT_EXTERN_TTAG_END = 419999,

///////////

	OUTLINEMAT_ADJUSTMENT_TRANSFORM_PIVOT_START = 0,
	OUTLINEMAT_ADJUSTMENT_TRANSFORM_PIVOT_END,
	OUTLINEMAT_ADJUSTMENT_TRANSFORM_PIVOT_CENTER,
	OUTLINEMAT_ADJUSTMENT_TRANSFORM_PIVOT_OBJECT,

	OUTLINEMAT_CLONE_PIVOT_START = 0,
	OUTLINEMAT_CLONE_PIVOT_END,
	OUTLINEMAT_CLONE_PIVOT_CENTER,
	OUTLINEMAT_CLONE_PIVOT_OBJECT,

	OUTLINEMAT_LINE_OUTLINE_SHOW_OBJS_OBJECT = 0,
	OUTLINEMAT_LINE_OUTLINE_SHOW_OBJS_WITHCHILD,
	OUTLINEMAT_LINE_OUTLINE_SHOW_OBJS_HIERARCHY,
	OUTLINEMAT_LINE_OUTLINE_SHOW_OBJS_SCENE,
	OUTLINEMAT_LINE_OUTLINE_SHOW_OBJS_OBJECTS,

	OUTLINEMAT_LINE_INTERESTION_OBJS_OBJECT = 0,
	OUTLINEMAT_LINE_INTERESTION_OBJS_WITHCHILD,
	OUTLINEMAT_LINE_INTERESTION_OBJS_HIERARCHY,
	OUTLINEMAT_LINE_INTERESTION_OBJS_SCENE,
	OUTLINEMAT_LINE_INTERESTION_OBJS_OBJECTS,

	OUTLINEMAT_ANIMATE_STROKES_LONGTOSHORT = 0,
	OUTLINEMAT_ANIMATE_STROKES_SHORTTOLONG,
	OUTLINEMAT_ANIMATE_STROKES_TOPBOTTOM,
	OUTLINEMAT_ANIMATE_STROKES_BOTTOMTOP,
	OUTLINEMAT_ANIMATE_STROKES_LEFTRIGHT,
	OUTLINEMAT_ANIMATE_STROKES_RIGHTLEFT,
	OUTLINEMAT_ANIMATE_STROKES_RANDOM,

	OUTLINEMAT_ANIMATE_STROKE_MODE_DRAW = 0,
	OUTLINEMAT_ANIMATE_STROKE_MODE_LENGTH,
	OUTLINEMAT_ANIMATE_STROKE_MODE_OPACITY,
	OUTLINEMAT_ANIMATE_STROKE_MODE_THICKNESS,
	OUTLINEMAT_ANIMATE_STROKE_MODE_BUILD,
//

	OUTLINEMAT_BLENDMODE_AVERAGE = 1,
	OUTLINEMAT_BLENDMODE_NORMAL,
	OUTLINEMAT_BLENDMODE_MULTIPLY,
	OUTLINEMAT_BLENDMODE_SCREEN,
	OUTLINEMAT_BLENDMODE_DARKEN,
	OUTLINEMAT_BLENDMODE_LIGHT,
	OUTLINEMAT_BLENDMODE_DIFFERENCE,
	OUTLINEMAT_BLENDMODE_NEGATIVE,
	OUTLINEMAT_BLENDMODE_EXCLUSION,
	OUTLINEMAT_BLENDMODE_OVERLAY,
	OUTLINEMAT_BLENDMODE_HARDLIGHT,
	OUTLINEMAT_BLENDMODE_SOFTLIGHT,
	OUTLINEMAT_BLENDMODE_DODGE,
	OUTLINEMAT_BLENDMODE_BURN,
	OUTLINEMAT_BLENDMODE_REFLECT,
	OUTLINEMAT_BLENDMODE_GLOW,
	OUTLINEMAT_BLENDMODE_FREEZE,
	OUTLINEMAT_BLENDMODE_HEAT,
	OUTLINEMAT_BLENDMODE_ADD,
	OUTLINEMAT_BLENDMODE_SUB,
	OUTLINEMAT_BLENDMODE_STAMP,
	OUTLINEMAT_BLENDMODE_XOR,
	OUTLINEMAT_BLENDMODE_HUE,
	OUTLINEMAT_BLENDMODE_SATURATION,
	OUTLINEMAT_BLENDMODE_LUMINANCE,
	OUTLINEMAT_BLENDMODE_RED,
	OUTLINEMAT_BLENDMODE_GREEN,
	OUTLINEMAT_BLENDMODE_BLUE,
	OUTLINEMAT_BLENDMODE_OVERWRITE,
	OUTLINEMAT_BLENDMODE_LEVR,

// Strokes

	OUTLINEMAT_START_SCREEN = 0,
	OUTLINEMAT_START_OBJECT,
	OUTLINEMAT_START_RANDOM,
	OUTLINEMAT_START_MESH,
	OUTLINEMAT_START_LEFTMOST,
	OUTLINEMAT_START_TOPMOST,
	OUTLINEMAT_START_RIGHTMOST,
	OUTLINEMAT_START_BOTTOMMOST,
	OUTLINEMAT_START_OUTMOST,
	OUTLINEMAT_START_INMOST,

	OUTLINEMAT_LINESTARTEND_ROUNDED = 0,
	OUTLINEMAT_LINESTARTEND_FLAT,
	OUTLINEMAT_LINESTARTEND_SQUARE,
	OUTLINEMAT_LINESTARTEND_LINEAR,
	OUTLINEMAT_LINESTARTEND_ARROW,
	OUTLINEMAT_LINESTARTEND_CUSTOM,

	OUTLINEMAT_JOINT_MITER = 0,
	OUTLINEMAT_JOINT_BEVEL,
	OUTLINEMAT_JOINT_ROUND,

	OUTLINEMAT_DIRECTION_CLOCKWISE = 0,
	OUTLINEMAT_DIRECTION_ANTICLOCKWISE,
	OUTLINEMAT_DIRECTION_LEFT,
	OUTLINEMAT_DIRECTION_RIGHT,
	OUTLINEMAT_DIRECTION_UPWARDS,
	OUTLINEMAT_DIRECTION_DOWN,

	OUTLINEMAT_END_OFF = 0,
	OUTLINEMAT_END_LENGTH,
	OUTLINEMAT_END_ANGLE,
	OUTLINEMAT_END_JOINT,

	OUTLINEMAT_CURVE_TYPE_LINEAR = 0,
	OUTLINEMAT_CURVE_TYPE_CUBIC,
	OUTLINEMAT_CURVE_TYPE_AKIMA,
	OUTLINEMAT_CURVE_TYPE_BSPLINE,
	OUTLINEMAT_CURVE_TYPE_BEZIER,

	OUTLINEMAT_CURVE_INTERPOLATION_NONE = 0,
	OUTLINEMAT_CURVE_INTERPOLATION_NATURAL,
	OUTLINEMAT_CURVE_INTERPOLATION_UNIFORM,
	OUTLINEMAT_CURVE_INTERPOLATION_ADAPTIVE,

	OUTLINEMAT_CONNECTIIONZ_ALL = 0,
	OUTLINEMAT_CONNECTIIONZ_CLOSEST,
	OUTLINEMAT_CONNECTIIONZ_THRESHOLD,
	OUTLINEMAT_CONNECTIIONZ_WORLD,

//

	OUTLINEMAT_NOISE_TYPE_BOX_NOISE             =  1,
	OUTLINEMAT_NOISE_TYPE_BLIST_TURB            =  2,
	OUTLINEMAT_NOISE_TYPE_BUYA                  =  3,
	OUTLINEMAT_NOISE_TYPE_CELL_NOISE            =  4,
	OUTLINEMAT_NOISE_TYPE_CRANAL                =  5,
	OUTLINEMAT_NOISE_TYPE_DENTS                 =  6,
	OUTLINEMAT_NOISE_TYPE_DISPL_TURB            =  7,
	OUTLINEMAT_NOISE_TYPE_FBM                   =  8,
	OUTLINEMAT_NOISE_TYPE_HAMA                  =  9,
	OUTLINEMAT_NOISE_TYPE_LUKA                  = 10,
	OUTLINEMAT_NOISE_TYPE_MOD_NOISE             = 11,
	OUTLINEMAT_NOISE_TYPE_NAKI                  = 12,
	OUTLINEMAT_NOISE_TYPE_NOISE                 = 13,
	OUTLINEMAT_NOISE_TYPE_NUTOUS                = 14,
	OUTLINEMAT_NOISE_TYPE_OBER                  = 15,
	OUTLINEMAT_NOISE_TYPE_PEZO                  = 16,
	OUTLINEMAT_NOISE_TYPE_POXO                  = 17,
	OUTLINEMAT_NOISE_TYPE_RANDOM                = 18,
	OUTLINEMAT_NOISE_TYPE_SEMA                  = 19,
	OUTLINEMAT_NOISE_TYPE_STUPL                 = 20,
	OUTLINEMAT_NOISE_TYPE_TURBULENCE            = 21,
	OUTLINEMAT_NOISE_TYPE_VL_NOISE              = 22,
	OUTLINEMAT_NOISE_TYPE_WAVY_TURB             = 23,
	OUTLINEMAT_NOISE_TYPE_CELL_VORONOI          = 24,
	OUTLINEMAT_NOISE_TYPE_DISPL_VORONOI         = 25,
	OUTLINEMAT_NOISE_TYPE_SPARSE_CONV           = 26,
	OUTLINEMAT_NOISE_TYPE_VORONOI_1             = 27,
	OUTLINEMAT_NOISE_TYPE_VORONOI_2             = 28,
	OUTLINEMAT_NOISE_TYPE_VORONOI_3             = 29,
	OUTLINEMAT_NOISE_TYPE_ZADA                  = 30,

	OUTLINEMAT_DUMMY = 0
};

#endif	// MOUTLINER_H__



